/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientManager;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfChatletClient;
import com.ibm.hwmca.fw.rbf.impl.RbfInternalConstants;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.util.HMCTimer;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.TimerParms;
import com.ibm.hwmca.fw.util.TimerTaskControl;
import com.ibm.hwmca.fw.util.TimerTaskExecutionControl;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class CommManager
implements RbfInternalConstants,
FcsService,
FcsEventListener {
    private static final String TRACE_MASKT = "XRBFCMGT";
    private static final String TRACE_MASKF = "XRBFCMGF";
    private static final String TRACE_MASKD = "XRBFCMGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-CommMgr");
    private static CommManager commManager = null;
    private static final FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.fw.rbf", 2.0);
    private Map peers = new HashMap();
    private Object peerLock = new Object();
    private Shepherd shepherd = new Shepherd();
    private static final long PEER_TIMEOUT = 1200000L;
    static final int OFFER_MSG_TIMEOUT = 360000;
    static final int DEFAULT_MSG_TIMEOUT = 180000;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$impl$RbfReply;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$impl$RbfMsg;

    private CommManager() {
        FcsServer fcsServer = FcsServer.getFcsServer();
        fcsServer.addLocalService(serviceId, this);
        fcsServer.addFcsEventListener(this);
        Trace.trace(TRACE_MASKT, "<> CommManager()");
    }

    public static synchronized CommManager getCommManager() {
        if (commManager == null) {
            commManager = new CommManager();
        }
        return commManager;
    }

    RbfReply send(RbfMsg msg, MachineId target) throws RbfException {
        return this.send(msg, target, 0);
    }

    RbfReply send(RbfMsg msg, MachineId target, int soTimeout) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> send(" + RbfUtils.getMachineInfo(target) + ")");
        FcsServer fcsServer = FcsServer.getFcsServer();
        MachineId localMachine = fcsServer.getLocalMachineId();
        RbfReply reply = null;
        if (target.equals(localMachine)) {
            reply = this.sendLocal(msg, target);
        } else {
            int commonProtocol = this.getCommonRbfVersion(target);
            if (commonProtocol == 1) {
                reply = this.sendRemote(msg, target, soTimeout, commonProtocol);
            } else if (commonProtocol >= 2) {
                reply = this.sendChatlet(msg, target, soTimeout, commonProtocol);
            } else {
                String desc = "Version 2 unsupported by target";
                Trace.trace(TRACE_MASKF, desc);
                throw new RbfException(desc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- send()");
        return reply;
    }

    private RbfReply sendLocal(RbfMsg msg, MachineId localMachine) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> sendLocal()");
        String localMachineInfo = RbfUtils.getMachineInfo(localMachine);
        int protocol = 2;
        String desc = "target=" + localMachineInfo + ", protocol=" + protocol + "\nOutgoing " + msg;
        Trace.trace(TRACE_MASKF, desc);
        RbfReply reply = msg.process(localMachine, protocol);
        String desc2 = "Incoming " + reply + "\nsender=" + localMachineInfo + ", protocol=" + protocol;
        Trace.trace(TRACE_MASKF, desc2);
        reply.process(localMachine, protocol);
        Trace.trace(TRACE_MASKT, "<- sendLocal()");
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RbfReply sendRemote(RbfMsg msg, MachineId target, int soTimeout, int protocol) throws RbfException {
        Object reply;
        block19: {
            Trace.trace(TRACE_MASKT, "-> sendRemote(" + soTimeout + ", " + protocol + ")");
            Socket socket = null;
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            String targetInfo = RbfUtils.getMachineInfo(target);
            FcsConnection connection = null;
            if (protocol == 2) {
                connection = FcsConnection.connect(target, serviceId);
            } else {
                FcsServiceId tempServiceId = new FcsServiceId("com.ibm.hwmca.fw.rbf", protocol);
                connection = FcsConnection.connect(target, tempServiceId);
            }
            socket = connection.getSocket();
            if (soTimeout > 0) {
                socket.setSoTimeout(soTimeout);
            }
            oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            oos.writeInt(protocol);
            oos.flush();
            ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
            int targetProtocol = ois.readInt();
            int commonProtocol = this.getCommonRbfVersion(targetProtocol);
            Trace.trace(TRACE_MASKF, "target=" + targetInfo + ", protocol=" + commonProtocol);
            if (commonProtocol == -1) {
                String desc = "Version 2 unsupported by target";
                Trace.trace(TRACE_MASKF, desc);
                throw new RbfException(desc);
            }
            Object desc = this.peerLock;
            synchronized (desc) {
                PeerInfo peerInfo = (PeerInfo)this.peers.get(target);
                if (peerInfo == null) {
                    peerInfo = new PeerInfo(target, commonProtocol);
                    this.addPeer(peerInfo);
                } else {
                    peerInfo.protocol = commonProtocol;
                    peerInfo.lastUse = System.currentTimeMillis();
                }
            }
            Trace.trace(TRACE_MASKF, "Outgoing " + msg);
            oos.writeObject(msg);
            oos.flush();
            reply = ois.readObject();
            desc = "Incoming " + reply + "\n" + "sender=" + targetInfo + ", protocol=" + commonProtocol;
            Trace.trace(TRACE_MASKF, (String)desc);
            if (!(reply instanceof RbfReply)) {
                desc = "Unexpected reply " + reply.getClass().getName() + " from " + targetInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfReply == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfReply = CommManager.class$("com.ibm.hwmca.fw.rbf.impl.RbfReply")) : class$com$ibm$hwmca$fw$rbf$impl$RbfReply).getName();
                Trace.trace(TRACE_MASKF, (String)desc);
                RbfException rbfe = new RbfException((String)desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                fl.add(RbfUtils.getLoggingInfo());
                fl.log();
                throw rbfe;
            }
            ((RbfReply)reply).process(target, commonProtocol);
            Object var17_20 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
                break block19;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            {
                break block19;
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e.getClass().getName() + " sending " + msg.getClass().getName() + " to " + targetInfo + ":\n " + RbfUtils.getStackTrace(e));
                    throw new RbfException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                Trace.trace(TRACE_MASKT, "<- sendRemote()");
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- sendRemote()");
        return (RbfReply)reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RbfReply sendChatlet(RbfMsg msg, MachineId target, int soTimeout, int protocol) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> sendChatlet(" + soTimeout + ", " + protocol + ")");
        String targetInfo = RbfUtils.getMachineInfo(target);
        RbfReply reply = null;
        try {
            RbfChatletClient chatletClient;
            Object object = this.peerLock;
            synchronized (object) {
                PeerInfo peerInfo = (PeerInfo)this.peers.get(target);
                if (peerInfo == null) {
                    peerInfo = new PeerInfo(target, protocol);
                    peerInfo.chatletClient = new RbfChatletClient(target);
                    this.addPeer(peerInfo);
                } else {
                    peerInfo.protocol = protocol;
                    peerInfo.lastUse = System.currentTimeMillis();
                    if (peerInfo.chatletClient == null) {
                        peerInfo.chatletClient = new RbfChatletClient(target);
                    }
                }
                chatletClient = peerInfo.chatletClient;
            }
            reply = chatletClient.sendMsg(msg, soTimeout, protocol);
        }
        catch (Exception e) {
            if (e instanceof RbfException) {
                throw (RbfException)e;
            }
            Trace.trace(TRACE_MASKF, e.getClass().getName() + " sending " + msg.getClass().getName() + " to " + targetInfo + ":\n " + RbfUtils.getStackTrace(e));
            throw new RbfException(e);
        }
        Trace.trace(TRACE_MASKT, "<- sendChatlet()");
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processConnection(FcsConnection connection) {
        block14: {
            String senderInfo;
            Socket socket;
            block12: {
                Trace.trace(TRACE_MASKT, "-> processConnection()");
                ObjectInputStream ois = null;
                ObjectOutputStream oos = null;
                socket = connection.getSocket();
                MachineId sender2 = connection.getMachineId();
                senderInfo = RbfUtils.getMachineInfo(sender2);
                ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                int senderProtocol = ois.readInt();
                int commonProtocol = this.getCommonRbfVersion(senderProtocol);
                oos = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                oos.writeInt(commonProtocol);
                oos.flush();
                Trace.trace(TRACE_MASKF, "sender=" + senderInfo + ", protocol=" + commonProtocol);
                if (commonProtocol == -1) break block12;
                Object msg = ois.readObject();
                Trace.trace(TRACE_MASKF, "Incoming " + msg);
                if (!(msg instanceof RbfMsg)) {
                    String desc = "Unexpected message " + msg.getClass().getName() + " from " + senderInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfMsg == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfMsg = CommManager.class$("com.ibm.hwmca.fw.rbf.impl.RbfMsg")) : class$com$ibm$hwmca$fw$rbf$impl$RbfMsg).getName();
                    Trace.trace(TRACE_MASKF, desc);
                    RbfException rbfe = new RbfException(desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                    fl.add(RbfUtils.getLoggingInfo());
                    fl.log();
                    throw rbfe;
                }
                RbfReply reply = ((RbfMsg)msg).process(sender2, commonProtocol);
                String desc = "Outgoing " + reply + "\ntarget=" + senderInfo + ", protocol=" + commonProtocol;
                Trace.trace(TRACE_MASKF, desc);
                oos.writeObject(reply);
                oos.flush();
            }
            Object var14_16 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKT, "<- processConnection()");
            {
                break block14;
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e.getClass().getName() + " processing " + "connection from " + senderInfo + ":\n " + RbfUtils.getStackTrace(e));
                    Object var14_17 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    Trace.trace(TRACE_MASKT, "<- processConnection()");
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                Trace.trace(TRACE_MASKT, "<- processConnection()");
                throw throwable;
            }
        }
    }

    int getCommonRbfVersion(int version) {
        if (version == -1) {
            return version;
        }
        if (version < 2) {
            return version;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCommonRbfVersion(MachineId machine) {
        FcsServer fcsServer = FcsServer.getFcsServer();
        FcsServiceId rbfService = fcsServer.getServiceId(machine, "com.ibm.hwmca.fw.rbf");
        if (rbfService != null) {
            int version = (int)rbfService.getVersion();
            if (version < 2) {
                return version;
            }
            return 2;
        }
        Object object = this.peerLock;
        synchronized (object) {
            PeerInfo peerInfo = (PeerInfo)this.peers.get(machine);
            if (peerInfo != null) {
                return peerInfo.protocol;
            }
            return 1;
        }
    }

    Set getPeers() {
        FcsServer fcsServer = FcsServer.getFcsServer();
        Set peers = fcsServer.getSupportingMachines(serviceId, 7);
        peers.remove(fcsServer.getLocalMachineId());
        return peers;
    }

    boolean containsRbfService(Set services) {
        String rbfServiceName = serviceId.getServiceName();
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            FcsServiceId serviceId = (FcsServiceId)iterator.next();
            if (!serviceId.getServiceName().equals(rbfServiceName)) continue;
            return true;
        }
        return false;
    }

    public void fcsStateChanged(FcsEvent event) {
        Trace.trace(TRACE_MASKT, "-> fcsStateChanged()");
        MachineId machine = event.getMachineId();
        Set services = event.getServices();
        if (this.containsRbfService(services)) {
            int type = event.getEventType();
            int details = event.getEventDetails();
            String machineInfo = RbfUtils.getMachineInfo(machine);
            if (type == 1) {
                if (details == 51) {
                    Trace.trace(TRACE_MASKF, "Machine added: " + machineInfo);
                } else if (details == 53) {
                    Trace.trace(TRACE_MASKF, "Machine recycled: " + machineInfo);
                } else if (details == 52) {
                    Trace.trace(TRACE_MASKF, "Machine removed: " + machineInfo);
                    this.removePeer(machine);
                } else if (details == 54) {
                    Trace.trace(TRACE_MASKF, "Machine changed: " + machineInfo);
                    this.updatePeer(machine, event.getOldMachineId());
                }
            } else if (type == 2) {
                if (details == 100) {
                    Trace.trace(TRACE_MASKF, "Service added: " + machineInfo);
                } else if (details == 101) {
                    Trace.trace(TRACE_MASKF, "Service removed: " + machineInfo);
                    this.removePeer(machine);
                }
            }
            try {
                HandlerManager.getHandlerManager().fcsStateChanged(event);
                RequestManager.getRequestManager().fcsStateChanged(event);
                RequestHandlingManager.getRequestHandlingManager().fcsStateChanged(event);
            }
            catch (PersistenceNotInitializedException pnie) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKT, "<- fcsStateChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPeer(PeerInfo peerInfo) {
        Trace.trace(TRACE_MASKT, "-> addPeer(" + RbfUtils.getMachineInfo(peerInfo.peer) + ")");
        Object object = this.peerLock;
        synchronized (object) {
            if (!this.peers.containsKey(peerInfo.peer)) {
                this.peers.put(peerInfo.peer, peerInfo);
                Trace.trace(TRACE_MASKF, "Added " + peerInfo);
            } else {
                Trace.trace(TRACE_MASKF, "Peer information already exists");
            }
            this.shepherd.schedule();
        }
        Trace.trace(TRACE_MASKT, "<- addPeer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePeer(MachineId machine, MachineId oldMachine) {
        Trace.trace(TRACE_MASKT, "-> updatePeer(" + RbfUtils.getMachineInfo(oldMachine) + ")");
        Object object = this.peerLock;
        synchronized (object) {
            if (this.peers.containsKey(oldMachine)) {
                PeerInfo peerInfo = (PeerInfo)this.peers.get(oldMachine);
                peerInfo.peer = machine;
                if (peerInfo.chatletClient != null) {
                    peerInfo.chatletClient.setTarget(machine);
                }
                this.peers.remove(oldMachine);
                this.peers.put(machine, peerInfo);
                Trace.trace(TRACE_MASKF, "Updated " + RbfUtils.getMachineInfo(machine));
            }
        }
        Trace.trace(TRACE_MASKT, "<- updatePeer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePeer(MachineId machine) {
        Trace.trace(TRACE_MASKT, "-> removePeer(" + RbfUtils.getMachineInfo(machine) + ")");
        Object object = this.peerLock;
        synchronized (object) {
            if (this.peers.containsKey(machine)) {
                PeerInfo peerInfo = (PeerInfo)this.peers.get(machine);
                if (peerInfo.chatletClient != null) {
                    this.shepherd.deregisterChatletClient(peerInfo.chatletClient);
                    peerInfo.chatletClient = null;
                }
                this.peers.remove(machine);
                Trace.trace(TRACE_MASKF, "Removed " + peerInfo);
            } else {
                Trace.trace(TRACE_MASKF, "No peer information found");
            }
        }
        Trace.trace(TRACE_MASKT, "<- removePeer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPeerDump() {
        StringBuffer sb = new StringBuffer();
        Object object = this.peerLock;
        synchronized (object) {
            sb.append("Peer information:");
            if (this.peers.isEmpty()) {
                sb.append("None");
            }
            Iterator iterator = this.peers.keySet().iterator();
            while (iterator.hasNext()) {
                MachineId peer = (MachineId)iterator.next();
                sb.append("\n" + ((PeerInfo)this.peers.get(peer)).toString());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isChatletClientUsed(RbfChatletClient chatletClient) {
        Trace.trace(TRACE_MASKT, "-> isChatletClientUsed(@" + chatletClient.hashCode() + ") " + RbfUtils.getMachineInfo(chatletClient.getTarget()));
        boolean used = false;
        Object object = this.peerLock;
        synchronized (object) {
            PeerInfo peerInfo = (PeerInfo)this.peers.get(chatletClient.getTarget());
            if (peerInfo != null && peerInfo.chatletClient != null && peerInfo.chatletClient == chatletClient) {
                used = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- isChatletClientUsed() " + used);
        return used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChatletClient(RbfChatletClient chatletClient, boolean deregister) {
        Trace.trace(TRACE_MASKT, "-> removeChatletClient(@" + chatletClient.hashCode() + ", " + deregister + ") " + RbfUtils.getMachineInfo(chatletClient.getTarget()));
        Object object = this.peerLock;
        synchronized (object) {
            PeerInfo peerInfo = (PeerInfo)this.peers.get(chatletClient.getTarget());
            if (peerInfo != null && peerInfo.chatletClient != null && peerInfo.chatletClient == chatletClient) {
                peerInfo.chatletClient = null;
            }
            if (deregister) {
                this.shepherd.deregisterChatletClient(chatletClient);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeChatletClient()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Shepherd
    implements HMCTimerTask {
        private TimerTaskControl timerTaskControl;
        private LinkedList unusedChatletClients = new LinkedList();
        private Object shepherdLock = new Object();

        private Shepherd() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregisterChatletClient(RbfChatletClient chatletClient) {
            Trace.trace(CommManager.TRACE_MASKT, "-> deregisterChatletClient(@" + chatletClient.hashCode() + ") " + RbfUtils.getMachineInfo(chatletClient.getTarget()));
            Object object = this.shepherdLock;
            synchronized (object) {
                if (!this.unusedChatletClients.contains(chatletClient)) {
                    this.unusedChatletClients.add(chatletClient);
                    this.schedule();
                }
            }
            Trace.trace(CommManager.TRACE_MASKT, "<- deregisterChatletClient()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule() {
            Object object = this.shepherdLock;
            synchronized (object) {
                if (this.timerTaskControl == null) {
                    HMCTimer timer = HMCTimer.getHMCTimer();
                    TimerParms parms = new TimerParms(1200000L, 1200000L, true);
                    this.timerTaskControl = timer.schedule((HMCTimerTask)this, parms);
                    Trace.trace(CommManager.TRACE_MASKF, "Shepherd scheduled");
                } else {
                    Trace.trace(CommManager.TRACE_MASKF, "Shepherd already scheduled");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TimerTaskExecutionControl timerTaskExecutionControl, Object runParms) {
            try {
                Object peerInfo;
                Trace.trace(CommManager.TRACE_MASKT, "-> Shepherd running");
                Trace.trace(CommManager.TRACE_MASKF, CommManager.this.getPeerDump());
                long lastUsedCutoff = System.currentTimeMillis() - 1200000L;
                Trace.trace(CommManager.TRACE_MASKF, "Searching for chatlet clients not used since " + new Date(lastUsedCutoff));
                Object object = CommManager.this.peerLock;
                synchronized (object) {
                    Object peerIds = CommManager.this.peers.keySet().iterator();
                    while (peerIds.hasNext()) {
                        peerInfo = (PeerInfo)CommManager.this.peers.get((MachineId)peerIds.next());
                        if (((PeerInfo)peerInfo).lastUse >= lastUsedCutoff || ((PeerInfo)peerInfo).chatletClient == null) continue;
                        this.deregisterChatletClient(((PeerInfo)peerInfo).chatletClient);
                        ((PeerInfo)peerInfo).chatletClient = null;
                    }
                    peerIds = this.shepherdLock;
                    synchronized (peerIds) {
                        if (CommManager.this.peers.size() <= 0 && this.unusedChatletClients.size() <= 0) {
                            this.cancel();
                        }
                    }
                }
                boolean finished = false;
                while (!finished) {
                    RbfChatletClient chatletClient = null;
                    peerInfo = this.shepherdLock;
                    synchronized (peerInfo) {
                        if (this.unusedChatletClients.size() > 0) {
                            chatletClient = (RbfChatletClient)this.unusedChatletClients.removeFirst();
                        }
                    }
                    if (chatletClient != null) {
                        if (chatletClient.isDestroyed()) continue;
                        MachineId target = chatletClient.getTarget();
                        Trace.trace(CommManager.TRACE_MASKF, "Deregistering unused chatlet client (@" + chatletClient.hashCode() + ") for " + RbfUtils.getMachineInfo(target));
                        try {
                            ChatletClientManager ccm = ChatletClientManager.getChatletClientManager(target);
                            ccm.deregisterChatlet(chatletClient);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    finished = true;
                }
                Trace.trace(CommManager.TRACE_MASKT, "<- Shepherd ending");
            }
            catch (Exception e) {
                new FrameworkLog(classLogInfo, 1059, e).log();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.shepherdLock;
            synchronized (object) {
                if (this.timerTaskControl != null) {
                    this.timerTaskControl.cancel();
                    this.timerTaskControl = null;
                    Trace.trace(CommManager.TRACE_MASKF, "Shepherd canceled");
                } else {
                    Trace.trace(CommManager.TRACE_MASKF, "Shepherd not scheduled");
                }
            }
        }
    }

    private class PeerInfo {
        MachineId peer;
        int protocol = 1;
        RbfChatletClient chatletClient = null;
        long lastUse = 0L;

        public PeerInfo(MachineId peer, int protocol) {
            this.peer = peer;
            this.protocol = protocol;
            this.lastUse = System.currentTimeMillis();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[PeerInfo peer=" + RbfUtils.getMachineInfo(this.peer));
            sb.append(", protocol=" + this.protocol);
            if (this.chatletClient != null) {
                sb.append(", chatletClient=@" + this.chatletClient.hashCode());
            } else {
                sb.append(", chatletClient=no");
            }
            sb.append(", lastUse=" + new Date(this.lastUse) + "]");
            return sb.toString();
        }
    }
}

